/*
 * Decompiled with CFR 0.152.
 */
package filenet.vw.api;

import filenet.vw.api.VWException;
import filenet.vw.api.VWLogDefinition;
import filenet.vw.api.VWLogQuery;
import filenet.vw.api.VWLogSub;
import filenet.vw.api.VWPersistentCollection;
import filenet.vw.api.VWSession;
import filenet.vw.server.IPECommands;
import filenet.vw.server.VWCommandSession;

public final class VWLog
extends VWPersistentCollection {
    public static final int QUERY_NO_OPTIONS = 0;
    public static final int QUERY_MIN_VALUES_INCLUSIVE = 32;
    public static final int QUERY_MAX_VALUES_INCLUSIVE = 64;
    public static final int QUERY_RESOLVE_NAMES = 8192;
    public static final int QUERY_GET_NO_TRANSLATED_SYSTEM_FIELDS = 2048;
    public static final int QUERY_SORT_DESCENDING_ENABLED = 16384;
    protected VWLogSub[] logServers = null;
    IPECommands[] cmdSessions = new IPECommands[1];

    public static String _get_FILE_DATE() {
        return "$Date: 2010-07-09 22:14:38 GMT $";
    }

    public static String _get_FILE_AUTHOR() {
        return "$Author: Kevin Bentley;096657649;kbentley@us.ibm.com (kbentley) $";
    }

    public static String _get_FILE_REVISION() {
        return "$Revision: /main/PUI_451_Int/PUI_460_Int/5 $";
    }

    protected VWLog(String name, VWSession serviceSession) throws VWException {
        super(name, serviceSession);
        this.cmdSessions[0] = this.cmdSession;
        this.logServers = new VWLogSub[1];
        this.logServers[0] = new VWLogSub(name, serviceSession, this.cmdSessions[0]);
    }

    public VWLogQuery startQuery(String indexName, Object[] firstValues, Object[] lastValues, int queryFlags, String filter, Object[] substitutionVars) throws VWException {
        if (indexName == null || indexName.length() > 0) {
            // empty if block
        }
        return new VWLogQuery(this, this.authorStr(indexName), firstValues, lastValues, queryFlags, filter, substitutionVars, 3);
    }

    public VWSession getServiceSession() {
        return this.serviceSession;
    }

    public String toString() {
        return this.getName();
    }

    public int getBufferSize() {
        return this.logServers[0].getBufferSize();
    }

    public void setBufferSize(int theNewSize) throws VWException {
        if (theNewSize < 1) {
            throw new VWException("vw.api.VWLogfetchBufferSizeInvalid", "Buffer size specified to fetch is not valid.");
        }
        for (int i = 0; i < this.logServers.length; ++i) {
            this.logServers[i].setBufferSize(theNewSize);
        }
    }

    public VWLogDefinition fetchLogDefinition() throws VWException {
        VWLogDefinition logDef = this.cmdSessions[0].getLogDefinition(this.name);
        logDef.setSession(this.getSession());
        return logDef;
    }

    protected int getServerCount() {
        int result = 0;
        if (this.logServers != null) {
            result = this.logServers.length;
        }
        return result;
    }

    public String getName() {
        return super.getName();
    }

    protected VWLogSub getSubLog(int serverNumber) throws VWException {
        VWLogSub result = null;
        if (serverNumber <= -1 || serverNumber >= this.logServers.length) {
            throw new VWException("vw.api.LServerIdOutofRange", "Server Id''s are out of range.");
        }
        result = this.logServers[serverNumber];
        return result;
    }

    protected String getDestination(String serviceName, int isolatedRegion) {
        return VWCommandSession.serverDestination(serviceName, 0, isolatedRegion);
    }
}

